//
//  GraphicsViewControllerView.m
//  Constructing Paths
//
//  Created by Vandad Nahavandipoor on 17/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "GraphicsViewControllerView.h"

@implementation GraphicsViewControllerView

- (id)initWithFrame:(CGRect)frame{
  self = [super initWithFrame:frame];
  if (self) {
    //  Miejsce na kod inicjalizacyjny.
  }
  return self;
}

/* 1 */
- (void)drawRect:(CGRect)rect{
  
  /* Utworzenie ścieżki. */
  CGMutablePathRef path = CGPathCreateMutable();
  
  /* Jaka jest wielkość ekranu? Chcemy, aby litera X wypełniła cały ekran. */
  CGRect screenBounds = [[UIScreen mainScreen] bounds];
  
  /* Rysowanie rozpoczynamy od lewego górnego rogu. */
  CGPathMoveToPoint(path,
                    NULL,
                    screenBounds.origin.x,
                    screenBounds.origin.y);
  
  /* Rysujemy linię od lewego górnego rogu ekranu do dolnego prawego. */
  CGPathAddLineToPoint(path,
                       NULL,
                       screenBounds.size.width,
                       screenBounds.size.height);
  
  /* Rozpoczynamy rysowanie innej linii w prawym górnym rogu ekranu. */
  CGPathMoveToPoint(path,
                    NULL,
                    screenBounds.size.width,
                    screenBounds.origin.y);
  
  /* Rysujemy linię od prawego górnego rogu ekranu do dolnego lewego. */
  CGPathAddLineToPoint(path,
                       NULL,
                       screenBounds.origin.x,
                       screenBounds.size.height);
  
  /* Pobranie kontekstu, w którym będzie narysowana ścieżka. */
  CGContextRef currentContext = UIGraphicsGetCurrentContext();
  
  /* Dodanie ścieżki do bieżącego kontekstu graficznego, aby można ją było później narysować. */
  CGContextAddPath(currentContext,
                   path);
  
  /* Zdefiniowanie koloru niebieskiego jako koloru ołówka. */
  [[UIColor blueColor] setStroke];
  
  /* Narysowanie ścieżki z użyciem zdefiniowanego koloru. */
  CGContextDrawPath(currentContext,
                    kCGPathStroke);
  
  /* Usunięcie obiektu ścieżki. */
  CGPathRelease(path);
  
}

@end
